package gov.va.med.mhv.rxrefill.util;

import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.enums.MhvStatusEnumeration;
import gov.va.med.mhv.rxrefill.enums.PrescriptionStatusEnumeration;

import org.springframework.stereotype.Component;

@Component
public final class PrescriptionUtils {
	
	/*
	public static final PrescriptionStatusEnumeration SUBMITTED_STATUS =
			PrescriptionStatusEnumeration.getEnum(PrescriptionStatusEnumeration.SUBMITTED);


	public static final PrescriptionStatusEnumeration UNKNOWN_STATUS =
			PrescriptionStatusEnumeration.getEnum(PrescriptionStatusEnumeration.UNKNOWN);


	public static final MhvStatusEnumeration MHV_PENDING_STATUS = 
			MhvStatusEnumeration.getEnum(MhvStatusEnumeration.PENDING);*/
	
	private PrescriptionUtils() {
		// Hide for utility class
	}
	
	public boolean isSubmitted(Prescription prescription) {
		return (prescription != null) && (prescription.getStatus() != null) 
				&& PrescriptionStatusEnumeration.SUBMITTED.getValue().equalsIgnoreCase(prescription.getStatus());
	}

	public boolean isActive(Prescription prescription) {
		return (prescription != null) && (prescription.getStatus() != null) 
			&& PrescriptionStatusEnumeration.ACTIVE.getValue().equalsIgnoreCase(prescription.getStatus());
	}

	public boolean isMHVPending(Prescription prescription) {
		return (prescription != null) && (prescription.getMhvStatus() != null) 
			&& MhvStatusEnumeration.PENDING.getValue() == prescription.getMhvStatus().intValue();
	}
}
